/*
 * Decompiled with CFR 0.152.
 */
package com.pannous.desktopctrl.client;

import com.pannous.desktopctrl.client.Keyboard;
import com.pannous.desktopctrl.client.TextController;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;

public final class TextTransfer
implements ClipboardOwner,
TextController {
    private Keyboard keyboard;

    public static void main(String ... aArguments) throws Exception {
        Clipboard clipBoard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable t = clipBoard.getContents(null);
        if (t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            System.out.println(t.getTransferData(DataFlavor.stringFlavor));
        }
        StringSelection data = new StringSelection("bla bla");
        clipBoard.setContents(data, data);
        System.out.println(clipBoard.getContents(null).getTransferData(DataFlavor.stringFlavor));
        System.in.read();
    }

    public TextTransfer(Keyboard keyboard) {
        this.keyboard = keyboard;
    }

    @Override
    public void lostOwnership(Clipboard aClipboard, Transferable aContents) {
    }

    public void setClipboardContents(String str) {
        if (Toolkit.getDefaultToolkit().getSystemSelection() != null) {
            StringSelection data = new StringSelection(str);
            Toolkit.getDefaultToolkit().getSystemSelection().setContents(data, this);
        }
    }

    public String getClipboardContents() {
        boolean hasTransferableText;
        String result = "";
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemSelection();
        if (Toolkit.getDefaultToolkit().getSystemSelection() == null) {
            return "";
        }
        Transferable contents = clipboard.getContents(null);
        boolean bl = hasTransferableText = contents != null && contents.isDataFlavorSupported(DataFlavor.stringFlavor);
        if (hasTransferableText) {
            try {
                result = (String)contents.getTransferData(DataFlavor.stringFlavor);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return result;
    }

    @Override
    public void write(String text) {
        this.setClipboardContents(text);
        this.keyboard.doPaste();
    }
}

