/*
 * Decompiled with CFR 0.152.
 */
package com.pannous.desktopctrl.client;

import com.jgoodies.common.collect.ArrayListModel;
import com.pannous.desktopctrl.client.Helper;
import com.pannous.desktopctrl.client.VoiceCommand;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class ConfigLoader {
    private String desktopHome;
    private String CUSTOM = "custom.properties";
    private String KEYBOARD = "keyboard.properties";
    private String MOUSE = "mouse.properties";
    private List<VoiceCommand> customCommands = new ArrayList<VoiceCommand>();
    private List<VoiceCommand> keyCommands = new ArrayList<VoiceCommand>();
    private List<VoiceCommand> mouseCommands = new ArrayList<VoiceCommand>();
    private ArrayListModel tm;

    public ConfigLoader(ArrayListModel allCommandsTableModel) {
        this.desktopHome = Helper.getHome();
        this.tm = allCommandsTableModel;
    }

    public void startReloadThread() {
        try {
            boolean forceWrite = true;
            Helper.useDefaultIfNotExistent(this.CUSTOM, forceWrite);
            Helper.useDefaultIfNotExistent(this.KEYBOARD, forceWrite);
            Helper.useDefaultIfNotExistent(this.MOUSE, forceWrite);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        new Thread("read commands"){

            @Override
            public void run() {
                while (true) {
                    ConfigLoader.this.refreshCommands();
                    try {
                        Thread.sleep(4000L);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        return;
                    }
                }
            }
        }.start();
    }

    public synchronized List<VoiceCommand> getCustomCommands() {
        return this.customCommands;
    }

    public synchronized List<VoiceCommand> getMouseCommands() {
        return this.mouseCommands;
    }

    public synchronized List<VoiceCommand> getKeyCommands() {
        return this.keyCommands;
    }

    List<VoiceCommand> parseCommands(String file) {
        try {
            String line;
            file = this.desktopHome + file;
            ArrayList<VoiceCommand> commands = new ArrayList<VoiceCommand>();
            HashSet<String> ids = new HashSet<String>();
            HashSet<String> allKeywords = new HashSet<String>();
            BufferedReader reader = new BufferedReader(new FileReader(file));
            VoiceCommand cmd = null;
            while ((line = reader.readLine()) != null) {
                if (line.trim().isEmpty() || line.startsWith("#")) continue;
                if (line.startsWith("id=")) {
                    String id = ConfigLoader.getValue(line);
                    if (!ids.add(id)) {
                        throw new RuntimeException("command id already exists:" + id);
                    }
                    cmd = new VoiceCommand(id);
                    commands.add(cmd);
                    continue;
                }
                if (line.startsWith("category=")) {
                    cmd.setCategory(ConfigLoader.getValue(line));
                    continue;
                }
                if (line.startsWith("description=")) {
                    cmd.setDescription(ConfigLoader.getValue(line));
                    continue;
                }
                if (line.startsWith("keywords=")) {
                    for (String kw : ConfigLoader.getValue(line).split(",")) {
                        if (kw.trim().isEmpty()) continue;
                        if (!allKeywords.add(kw.trim())) {
                            throw new RuntimeException("keyword for " + cmd.getId() + " already exists:" + kw);
                        }
                        cmd.addKeyword(kw.trim());
                    }
                    continue;
                }
                if (line.startsWith("shortcuts=")) {
                    for (String sc : ConfigLoader.getValue(line).split(",")) {
                        if (sc.trim().isEmpty()) continue;
                        cmd.addCommand(sc.trim());
                    }
                    continue;
                }
                throw new IllegalStateException("key " + line + " not recognized");
            }
            return commands;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    static String getValue(String line) {
        String[] spl = line.split("\\=");
        if (spl.length != 2) {
            throw new IllegalArgumentException("line does not have key=value format! " + line);
        }
        String value = spl[1].trim();
        if (value.isEmpty()) {
            throw new IllegalArgumentException("value in line is empty:" + line);
        }
        return value;
    }

    public synchronized Set<VoiceCommand> getAllCommands() {
        LinkedHashSet<VoiceCommand> allCommands = new LinkedHashSet<VoiceCommand>();
        this.customCommands = this.parseCommands(this.CUSTOM);
        this.keyCommands = this.parseCommands(this.KEYBOARD);
        for (VoiceCommand c : this.keyCommands) {
            c.setCategory("keyboard");
            c.setDescription("press " + c.getId());
        }
        this.mouseCommands = this.parseCommands(this.MOUSE);
        for (VoiceCommand c : this.mouseCommands) {
            c.setCategory("mouse");
            c.setDescription(c.getId());
        }
        allCommands.addAll(this.customCommands);
        allCommands.addAll(this.keyCommands);
        allCommands.addAll(this.mouseCommands);
        return allCommands;
    }

    public synchronized void refreshCommands() {
        this.tm.clear();
        for (VoiceCommand vc : this.getAllCommands()) {
            this.tm.add(vc);
        }
    }
}

